<?php
/**
 * config.php (PDO + MySQLi)
 * - $conn  : PDO connection (للـ API الجديد)
 * - $pdo   : Alias لنفس اتصال PDO
 * - $mysqli: MySQLi connection (لأي سكربتات قديمة تعتمد mysqli)
 */

// ========================
// 1) إعدادات قاعدة البيانات
// ========================
$DB_HOST = "localhost";
$DB_NAME = "yamacxmy_yemencash";
$DB_USER = "yamacxmy_zaherahmed620";
$DB_PASS = "@Ahmed62000";

// (اختياري) إعدادات عامة
define("SITE_NAME", "YemenCash");
define("SITE_URL",  "https://yemencash.net");

// ========================
// 2) PDO Connection  ($conn)
// ========================
$pdo  = null;
$conn = null;

if (extension_loaded('pdo_mysql')) {
  try {
    // DSN مثال رسمي لاتصالات PDO MySQL (يمكن إضافة charset) :contentReference[oaicite:0]{index=0}
    $dsn = "mysql:host={$DB_HOST};dbname={$DB_NAME};charset=utf8mb4";

    $pdo = new PDO($dsn, $DB_USER, $DB_PASS, [
      // تفعيل الاستثناءات لأخطاء SQL في PDO :contentReference[oaicite:1]{index=1}
      PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
      PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
      PDO::ATTR_EMULATE_PREPARES => false,
    ]);

    // متغير API الأساسي
    $conn = $pdo;

  } catch (Throwable $e) {
    // لا تطبع للمستخدم (حتى لا تنكسر JSON) — فقط سجّل في error_log
    error_log("PDO_CONNECT_FAIL: " . $e->getMessage());
    $pdo = null;
    $conn = null;
  }
} else {
  error_log("PDO driver pdo_mysql not loaded");
}

// ========================
// 3) MySQLi Connection ($mysqli)
// ========================
$mysqli = null;

if (extension_loaded('mysqli')) {
  // mysqli::__construct يُرجع كائن دائمًا حتى لو فشل، لذا نتحقق من connect_errno :contentReference[oaicite:2]{index=2}
  $mysqli = @new mysqli($DB_HOST, $DB_USER, $DB_PASS, $DB_NAME);

  if ($mysqli->connect_errno) {
    error_log("MYSQLI_CONNECT_FAIL: " . $mysqli->connect_error);
    $mysqli = null;
  } else {
    // ضبط الترميز بالطريقة الموصى بها في manual :contentReference[oaicite:3]{index=3}
    if (!$mysqli->set_charset("utf8mb4")) {
      error_log("MYSQLI_SET_CHARSET_FAIL: " . $mysqli->error);
    }
  }
} else {
  error_log("MySQLi extension not loaded");
}
